<?php
/* --------------------------------------------------------------
  StyleEdit3ReaderWrapper.inc.php 2019-07-23
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

use StyleEdit\StyleConfigReader;

/**
 * Class StyleEdit3ReaderWrapper
 */
class StyleEdit3ReaderWrapper implements StyleEditReaderInterface
{
    /**
     * @var StyleConfigReader
     */
    protected $reader;
    
    /**
     * @var StyleEdit3Service
     */
    protected $service;
    
    
    /**
     * StyleEdit3ReaderWrapper constructor.
     *
     * @param string $themeId
     */
    public function __construct(string $themeId)
    {
        if (!class_exists(StyleConfigReader::class)) {
            throw new RuntimeException('Class \'StyleEdit\StyleConfigReader\' not found');
        }
        
        $this->service = StyleEditServiceFactory::service();
        $this->reader  = StyleConfigReader::getInstance($themeId, $this->service->getStyleName());
    }
    
    
    /**
     * Get Sass Code by group and style name
     *
     * @param string $p_group
     *
     * @return string
     */
    public function getScss($p_group): string
    {
        return $this->reader->getScss($p_group, $this->service->getStyleName());
    }
    
    
    /**
     * Returns the custom styles from a JSON File
     *
     * @return string
     */
    public function getCustomStyles(): string
    {
        return $this->reader->getCustomStyles($this->service->getStyleName());
    }
    
    
    /**
     * Searches for a setting value identified by its name. If no result is found, null will be returned.
     *
     * @param $p_settingName
     *
     * @return mixed|null
     */
    public function findSettingValueByName($p_settingName)
    {
        return $this->reader->findSettingValueByName($p_settingName);
    }
    
    
    /**
     * Returns error message
     *
     * @return string
     */
    public function getErrorMessage(): string
    {
        return $this->reader->getErrorMessage();
    }
    
    
    /**
     * Adapter Method
     *
     * @param string $p_boxName
     *
     * @return bool
     */
    public function get_status($p_boxName): bool
    {
        return $this->reader->get_status($p_boxName);
    }
    
    
    /**
     * Adapter Method
     *
     * @param string $p_boxName
     *
     * @return string
     */
    public function get_position($p_boxName): string
    {
        return $this->reader->get_position($p_boxName);
    }

    /**
     * Adapter Method
     *
     * @param int $position
     *
     * @return bool
     */
    public function get_status_by_position($position): bool
    {
        return $this->reader->getStatusByPosition($position);
    }
}